/* 
 * spawn.c 
 *
 * Створює дочірній процес і запускає в ньому задану програму.
 * Ілюструє порядок застосування функцій fork(), wait(), execvp().
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>


/* Створює дочірній процес і запускає в ньому програму program
   із аргументами, заданими через масив argv.
   Повертає PID дочірнього процесу. */
int spawn(char *program, char *argv[])
{
        pid_t child_pid;

        /* Створює дочірній процес. */    
        child_pid = fork();
        if (child_pid != 0)
                /* Це батьківський процес */
                return child_pid;
        else {
                /* Це дочірній процес */
                /* Запускає задану програму. */
                execvp(program, argv);
                /* Функція execvp() повертає управління
                   тільки у випадку помилки. */
                perror("execvp");
                exit(EXIT_FAILURE);
        }
}

int main(int argc, char *argv[])
{
        if (argc == 1)
                exit(EXIT_SUCCESS);
        
        /* Запускає програму, вказану в аргументах,
           у дочірньому процесі. */
        if (spawn(argv[1], &argv[1]) == -1) {
                perror("fork");
                exit(EXIT_FAILURE);
        }
        /* Чекає на завершення дочірнього процесу. */
        wait(NULL);

        exit(EXIT_SUCCESS);
}
